unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  {   }
  UBmpTools;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    CheckBoxSTRETCH: TCheckBox;
    Panel2: TPanel;
    btnClose: TBitBtn;
    btnROZJASNIJ: TBitBtn;
    btnPRZYCIEMNIJ: TBitBtn;
    btnNegatyw: TBitBtn;
    btnOdbicieH: TBitBtn;
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxSTRETCHClick(Sender: TObject);
    procedure btnROZJASNIJClick(Sender: TObject);
    procedure btnPRZYCIEMNIJClick(Sender: TObject);
    procedure btnNegatywClick(Sender: TObject);
    procedure btnOdbicieHClick(Sender: TObject);

  private

  public

  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.btnCloseClick(Sender: TObject);
begin
	Close();
end;

procedure TForm1.CheckBoxSTRETCHClick(Sender: TObject);
begin
   Image1.Stretch := true;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	fn : String;

begin
	fn := 'trawa.bmp';
   Image1.Picture.LoadFromFile(fn);
end;

procedure TForm1.btnPRZYCIEMNIJClick(Sender: TObject);
var
	ob : BmpTools;

begin
	ob := BmpTools.Create();
   ob.Darkness(Image1.Picture.Bitmap, 5);
   FreeAndNil(Ob);
	Image1.Invalidate();
end;

procedure TForm1.btnROZJASNIJClick(Sender: TObject);
var
	ob : BmpTools;

begin
	ob := BmpTools.Create();
   ob.Lightness(Image1.Picture.Bitmap, 20);
   FreeAndNil(Ob);
	Image1.Invalidate();
end;

procedure TForm1.btnNegatywClick(Sender: TObject);
var
	ob  : BmpTools;
   bmp : TBitmap;

begin
   bmp := TBitmap.Create();
   bmp.Assign(Image1.Picture.Bitmap);

	ob := BmpTools.Create();
   ob.Negative(bmp);
   FreeAndNil(Ob);

   Image1.Picture.Bitmap := bmp;
	Image1.Invalidate();

   FreeAndNil(bmp);
end;

procedure TForm1.btnOdbicieHClick(Sender: TObject);
var
	ob  : BmpTools;
   bmp : TBitmap;

begin
   bmp := TBitmap.Create();
   bmp.Assign(Image1.Picture.Bitmap);

	ob := BmpTools.Create();
   ob.FlipHorizontal(bmp);
   FreeAndNil(Ob);

   Image1.Picture.Bitmap := bmp;
	Image1.Invalidate();

   FreeAndNil(bmp);
end;

end.

